<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template name="SHOW_ENTITY">
    <xsl:param name="subtitle"></xsl:param>
    <xsl:param name="dir"></xsl:param>
    <!-- // template -->
    <xsl:if test="$dir/Entity">
    <tr>
      <td colspan="3" class="td_invisible">
        <strong><xsl:value-of select="$subtitle"/></strong>
      </td>
    </tr>
      <tr>
        <td>Type</td><td>Count</td><td>Loaded</td><td>Skipped</td>
      </tr>
    <xsl:for-each select="$dir/Entity">
      <tr>
        <td><xsl:value-of select="@Type"/></td>
        <td><xsl:value-of select="@Count"/></td>
        <td><xsl:value-of select="@Loaded"/></td>
        <td>
          <xsl:value-of select="@Skipped"/>
          <xsl:if test="//Report/UnsupportedTypes/Type/@Val = @Type">*<!-- // marker of unsupported type -->
          </xsl:if>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:if>
</xsl:template>

  <xsl:template match="/">
    <html>
      <head>
        <style type="text/css">
          p {
          margin: 0;
          }
          h3 {
          font-weight: bold;
          font-size: 1.2em;
          margin-top: 1em;
          margin-bottom: 1em;
          text-align: left;
          text-decoration: none;
          }
  
          td.td_invisible {
          background: #ffffff;
          border: 0px solid #dcdcdc;
          padding: 0px;
          margin-top: 0.5em;
          }

          body {
          font-family: Verdana, Helvetica, sans-serif;
          font-size: 11px;
          margin-left: 1em;
          }

          table {
          font-size: 1em;
          margin-bottom: 1.5em;
          border-spacing: 10px;
          }

          td {
          background: #f9f9f9;
          border: 1px solid #dcdcdc;
          padding: 2px;
          vertical-align: top
          }

          a.toggle {
          font-weight: bold;
          color: black;
          text-decoration: none;
          }

          div.hidden {
          display: none;
          }
        </style>
        <script type="text/javascript">
          <!-- // toggle visibility -->
          function toggle(targetId, targetToggleId)
          {
          if (document.getElementById) {
          obj = document.getElementById(targetId);
          objToggle = document.getElementById(targetToggleId);
          if (obj.style.display == "none") {
          obj.style.display = "block";
          objToggle.title = "Hide";
          objToggle.innerHTML = "-" + objToggle.innerHTML.substring(1);
          }
          else {
          obj.style.display = "none";
          objToggle.title = "Show";
          objToggle.innerHTML = "+" + objToggle.innerHTML.substring(1);
          }
          }
          }
        </script>

      </head>
      <title>Report</title>
      <body>
        <h3>
          Loaded objects
        </h3>
        <h3>
          <a id="link_geometry" class="toggle" href="#" onclick="toggle('geometry', 'link_geometry');return false;" title="Show">+ Geometry</a>
        </h3>
        <table>
          <tbody id="geometry" style="display:none;">
            <!-- // points -->
            <!-- // curves -->
            <!-- // surfaces -->
            <xsl:call-template name="SHOW_ENTITY">
              <xsl:with-param name="subtitle"></xsl:with-param>
              <xsl:with-param name="dir" select ="//Report/Summary/Geometry"></xsl:with-param>
            </xsl:call-template>
          </tbody>
        </table>
        <!-- // Topology -->
        <h3>
          <a id="link_topo" class="toggle" href="#" onclick="toggle('topo', 'link_topo');return false;" title="Show">+ Topology</a>
        </h3>
        <table>
          <tbody id="topo" style="display:none;">
            <xsl:call-template name="SHOW_ENTITY">
              <xsl:with-param name="subtitle"></xsl:with-param>
              <xsl:with-param name="dir" select ="//Report/Summary/Topology"></xsl:with-param>
            </xsl:call-template>
          </tbody>
        </table>
        <!-- // Pmi -->
        <h3>
          <a id="link_pmi" class="toggle" href="#" onclick="toggle('pmi', 'link_pmi');return false;" title="Show">+ Pmi</a>
        </h3>
        <table>
          <tbody id="pmi" style="display:none;">
            <xsl:call-template name="SHOW_ENTITY">
              <xsl:with-param name="subtitle"></xsl:with-param>
              <xsl:with-param name="dir" select ="//Report/Summary/PMI"></xsl:with-param>
            </xsl:call-template>
          </tbody>
        </table>
        <!-- // Unsorted -->
        <h3>
          <a id="link_unsorted" class="toggle" href="#" onclick="toggle('unsorted', 'link_unsorted');return false;" title="Show">+ Other</a>
        </h3>
        <table>
          <tbody id="unsorted" style="display:none;">
            <xsl:call-template name="SHOW_ENTITY">
              <xsl:with-param name="subtitle"></xsl:with-param>
              <xsl:with-param name="dir" select ="//Report/Summary/Unsorted"></xsl:with-param>
            </xsl:call-template>
          </tbody>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
