

' ----- Linken Wert eines durch Komma getrennten Wertes ermitteln ----
function LeftValue(value)
  dim pos,l1,l2

  pos = instr(value,",")

  if pos = 0 then
    LeftValue = value
  else
    l1 = pos-1
    l2 = len(value) - pos 
    LeftValue = left(value,l1)
  end if
end function



' ----- Rechten Wert eines durch Komma getrennten Wertes ermitteln ----
function RightValue(value)
  dim pos,l1,l2

  pos = instr(value,",")

  if pos = 0 then
    RightValue = value
  else
    l1 = pos-1
    l2 = len(value) - pos 
    RightValue = right(value,l2)
  end if
end function


'------ Pfad zusammenbauen ---
function BuildPath(parent, child)
  dim l

  l = len(parent)
  if l=0 then
    BuildPath = child
  else 
    if (mid(parent,l,1)="/") OR (mid(parent,l,1)="\\") then
       BuildPath = parent + child
    else
       BuildPath = parent + "/" + child
    end if
  end if
end function  




'-------------------------------------------------------------------------
dim userPath        'Pfad fr CADENS_USER
dim psolPath        'Pfad fr CADENAS_SETUP
dim configMainPath  'Pfad fr main.cfg
dim configUserPath 'Pfad fr offuser.cfg
dim configMain      'Config fr main.cfg
dim configUser      'Config fr offuser.cfg
dim mversion        'Versionsnummer in main.cfg
dim mcdname         'Name in main.cfg
dim sversion        'Versionsnummer in start.cfg
dim scdname         'Name in start.cfg
dim mustCopy        'Wenn kopiert werden muss
dim i
dim key,value,dpath,spath,dest,sname,dname
dim debugFile


'set debugFile = application.tools.fso.CreateTextFile("c:/test.txt",1)
'debugFile.WriteLine("Debug-Output")


'----- Falls $TEMP nicht definiert ist, dann auf $TMP setzen ----------------
if (StrComp(application.ResolveEnv("$TEMP"),"$TEMP",0)=0) OR (len(application.ResolveEnv("$TEMP"))=0) then
   tmpres = application.ResolveEnv("$TMP")
   application.environment.addVarPre("TEMP",tmpres)
end if


userPath = application.ResolveEnv("$CADENAS_USER")
psolPath = application.ResolveEnv("$CADENAS")


'---- Lesen der main.cfg -------------------------------------
configMainPath = application.ResolveEnv("$CADENAS_SETUP/pcdstart.cfg")
set configMain = application.tools.configmgr.Open(configMainPath)


'-- Version aus main.cfg ermitteln
mversion = configMain.GetEntry("COMMON","VERSION")    
mcdname = configMain.GetEntry("COMMON","CDNAME")


'-- CADENAS_USER erstellen, falls es noch nicht existiert
application.tools.fso.CreateFolder(userPath)


'----- Erzeugen von CADENAS_LANGUAGE ------------------------------
'language is now set with PARTcdstart.exe
'dest = application.tools.configmgr.Open(application.ResolveEnv("$CADENAS_USER/cdstart.cfg")).GetEntry("COMMON","LANGUAGE")
'if dest <> "" then
'   application.environment.addVarPre("CADENAS_LANGUAGE",dest)
'   application.environment.addVarPre("cadenas_language",dest)
'end if


'----- Erzeugen von CADENAS_DATA ------------------------------
dest = application.ResolveEnv("$CADENAS_DATA")
      application.environment.addVarPre("cadenas_data",dest)

 
'---- Lesen der Datei offuser.cfg ----------------
configUserPath = application.ResolveEnv("$CADENAS_USER/offuser.cfg")
set configUser = application.tools.configmgr.Open(configUserPath)


'-- Verstion aus offuser.cfg ermitteln
sversion = configUser.GetEntry("COMMON","VERSION")
scdname =  configUser.GetEntry("COMMON","CDNAME")

'-- Version in offuser.cfg bertragen
configUser.AddEntry("COMMON","VERSION",mversion)
configUser.AddEntry("COMMON","CDNAME",mcdname)
configUser.SaveConfig()


'-- Prfen, ob Dateien kopiert werden sollen --
if (mversion <> sversion) OR (mcdname <> scdname) then
  mustCopy = 1
else
  mustCopy = 0
end if



' ---- Erzeugen von Verzeichnissen --
i=0
do
  key = "MKD" + cstr(i)
  value = configMain.GetEntry("COPYTMP",key)
  
  if len(value) > 0  then
    dpath = BuildPath(userPath,value)
    application.tools.fso.CreateFolder(dpath)
  end if
  i = i + 1
loop while len(value) > 0


'---- Kopieren von Verzeichnissen---
'kopiert wird, falls Datei nicht vorhanden oder mustCopy=1
i=0
do
  key = "COPYFOLDER" + cstr(i)
  value = configMain.GetEntry("COPYTMP",key)

  if len(value) > 0 then
    sname = LeftValue(value)   'Quellpfad relativ zum $CADENAS
    dname = RightValue(value)  'Zielpfad relativ zum  $CADENAS_USER
   
    spath = BuildPath(psolPath,sname)
    dpath = BuildPath(userPath,dname)

    '-- wenn Quelle ein Folder, dann Folder kopieren
    if application.tools.fso.FolderExists(spath) = 1 then
      if mustCopy OR (application.tools.fso.FolderExists(dpath) = 0) then
        application.tools.fso.Copyfolder(spath,dpath)
      end if
    end if

  end if
  i = i + 1
loop while len(value) > 0



'---- Kopieren von Dateien ---
'kopiert wird, falls Datei nicht vorhanden oder mustCopy=1
i=0
do
  key = "COPY" + cstr(i)
  value = configMain.GetEntry("COPYTMP",key)

  if len(value) > 0 then
    sname = LeftValue(value)   'Quellpfad relativ zum $CADENAS
    dname = RightValue(value)  'Zielpfad relativ zum  $CADENAS_USER
   
    spath = BuildPath(psolPath,sname)
    dpath = BuildPath(userPath,dname)

    '-- wenn Quelle eine Datei, dann Datei kopieren
    if application.tools.fso.FileExists(spath) = 1 then
      if mustCopy OR (application.tools.fso.FileExists(dpath) = 0) then
        application.tools.fso.copyFile(spath,dpath)
      end if
    end if
  end if
  i = i + 1
loop while len(value) > 0


' --- customizing for ERP-Demo-Offline DISK --- BEGIN

function fileExists( filename )
  dim fso
  set fso = CreateObject("Scripting.FileSystemObject")
  fileExists = fso.FileExists(filename)
end function

dim DATABASE_NAME_DESTINATION

'Dieser Wert wird auch in der copylinkdb.vbs des Offline-CD-Generators verwendet.
'Er darf also nicht gendert werden!
DATABASE_NAME_DESTINATION = "PLinkDbOffline"
FILENAME_DB               = DATABASE_NAME_DESTINATION & ".s3db"

dbpath = Replace( psolPath & "\\" & FILENAME_DB, "\\", "/" )

if fileExists(dbpath) = true then
  jdbccfgUserPath = application.ResolveEnv("$CADENAS_USER/jdbc.cfg")
  set jdbccfgUser = application.tools.configmgr.Open(jdbccfgUserPath)
  
  jdbccfgUser.AddEntry(DATABASE_NAME_DESTINATION, "Server"      , "localhost"               )
  jdbccfgUser.AddEntry(DATABASE_NAME_DESTINATION, "ServerDB"    , DATABASE_NAME_DESTINATION )
  jdbccfgUser.AddEntry(DATABASE_NAME_DESTINATION, "DriverClass" , "SQLite.JDBCDriver"       )
  jdbccfgUser.AddEntry(DATABASE_NAME_DESTINATION, "URL"         , "jdbc:sqlite:/" & dbpath  )
  
  jdbccfgUser.SaveConfig()
end if

' --- customizing for ERP-Demo-Offline DISK --- END



'debugFile.close()


